<!-- @noSnoop -->
require(['baja!',
          'jquery',
          'Promise'], function (
         baja,
         $,
         Promise) {

  'use strict';

  var audioPlayer = document.getElementById('beep');
  var display;
  var zone;
    
  function playSound(beeps){
    var counter = beeps;
    
    const repeatPlay = function() {
      setTimeout(function(){
        $('#beep')[0].play();
      }, 500);
      
      counter--;
      
      if(counter <= 1) {
        audioPlayer.removeEventListener('ended', repeatPlay);
      }
    };
    
    if(counter > 1) {
      counter--;
      audioPlayer.addEventListener('ended', repeatPlay);
      //repeatPlay();  
    }
    //else { $('#beep')[0].play(); }
    $('#beep')[0].play();
  }
  
  function updateAlarm() {
    if(!zone) { return; }
    var alarmCount = zone.get('inAlarmCount').valueOf();
    if(alarmCount === 0) {
      $('#line4').text("").removeClass("in-alarm");
    }
    else {
      $('#line4').text("ZONE ALARM COUNT: " + zone.get('inAlarmCount').valueOf()).addClass("in-alarm");
    }
  }  
  
  function update() {
    if(!display) { return; }
    $('#line1').text(display.get('line1').getValue());
    $('#line2').text(display.get('line2').getValue());
    $('#line3').text(display.get('line3').getValue());
  }
  
  function toggleLine1() {
    if(!display) { return; }
    if(display.get('invertLine1').getValue()) {
      $('#line1').addClass("invert");
    }
    else {
      $('#line1').removeClass("invert");
    }
  }
  
  function toggleLine2() {
    if(!display) { return; }
    if(display.get('invertLine2').getValue()) {
      $('#line2').addClass("invert");
    }
    else {
      $('#line2').removeClass("invert");
    }
  }
  
  function toggleLine3() {
    if(!display) { return; }
    if(display.get('invertLine3').getValue()) {
      $('#line3').addClass("invert");
    }
    else {
      $('#line3').removeClass("invert");
    }
  }
  
  function sendHeartbeat() {
    if(!display) { return; }
    if(display.has('heartbeat')) {
      display.set({
        slot: 'heartbeat',
        value: baja.AbsTime.now()
      });
      setInterval(function() {
        display.set({
          slot: 'heartbeat',
          value: baja.AbsTime.now()
        });
      }, 15000);
    }
    else {
      console.log('"heartbeat" slot not found on ' + Intrusion_Display_Path);
    }
  }
  
  $('.nmbrBtn').click(function() {
    $('#beep')[0].play();
    display.invoke({
      slot: 'keyPressed',
      value: baja.$('baja:String', $(this).text())
    });
  });
  
  $('.F1Btn').click(function() {
    $('#beep')[0].play();
    display.invoke({
      slot: 'keyPressed',
      value: baja.$('baja:String', '<F1>')
    });
  });
  
  $('.F2Btn').click(function() {
    $('#beep')[0].play();
    display.invoke({
      slot: 'keyPressed',
      value: baja.$('baja:String', '<F2>')
    });
  });
  
  $('.F3Btn').click(function() {
    $('#beep')[0].play();
    display.invoke({
      slot: 'keyPressed',
      value: baja.$('baja:String', '<F3>')
    });
  });
  
  $('.F4Btn').click(function() {
    $('#beep')[0].play();
    display.invoke({
      slot: 'keyPressed',
      value: baja.$('baja:String', '<F4>')
    });
  });
  
  // A Subscriber is used to listen to Component events in Niagara.
  var sub = new baja.Subscriber();
  sub.attach({
    changed: function (prop) {
      if (prop.getName().startsWith('line')) { update(); }
      else if(prop.getName() === 'invertLine1') { toggleLine1(); }
      else if(prop.getName() === 'invertLine2') { toggleLine2(); }
      else if(prop.getName() === 'invertLine3') { toggleLine3(); }
      else if(prop.getName() === 'inAlarmCount') { updateAlarm(); }
    },
    
    topicFired: function (topic, event, cx) {
      if(topic.getName() === 'beep') {
        var beeps = event.valueOf();
        if(beeps === 255) playSound(30);  // zone alarm 255 -> how many beeps to play
        else playSound(beeps);
      }
    }  
  });

  addEventListener('unload', (event) => {
    if(sub !== null) {
      sub.unsubscribeAll();
      sub.detach();
    }  
  });
  
  // Resolve the ORD to the intrusion display and update the text.
  var promise1 = baja.Ord.make(Intrusion_Display_Path).get({subscriber: sub})
  .then((base) => {
      display = base;
      update();
      toggleLine1();
      toggleLine2();
      toggleLine3();
      sendHeartbeat()
    });
  
  // Resolve the ORD to the intrusion zone
  var promise2 = baja.Ord.make(Intrusion_Zone_Path).get({subscriber: sub})
  .then((base) => {
    zone = base;
    updateAlarm();
  });
  
  return Promise.all([ promise1, promise2 ]);
  
});

